
function [OffOcc,Freq,Dur,Amp] = offdetection(LFP, SpkBin, AmpThresh, ISIThresh)

OffOcc = zeros(1,43200);
Freq = zeros(1,43200);
Dur = zeros(1,43200);
Amp = zeros(1,43200);

for n=1:43200
    t1_lfp = (n-1)*1024 +1;
    t2_lfp = n*1024;
    lfp = LFP(t1_lfp:t2_lfp);
    t1_ms = (n-1)*4000 +1;
    t2_ms = n*4000; 
    spkbin = SpkBin(t1_ms:t2_ms);
    
    % Find all positive half waves
    pos = lfp > 0;
    dp = diff(pos);
    wavestart = find(dp==1);
    waveend = find(dp==-1);
    if pos(1)
        waveend = waveend(2:end);
    end
    if pos(end)
        wavestart = wavestart(1:end-1);
    end
    
    % Apply amplitude threshold
    nWav = length(wavestart);
    amp = zeros(1,nWav);
    TPeak = zeros(1,nWav);
    for i=1:nWav
        wave = lfp(wavestart(i):waveend(i));
        [amp(i), idx] = max(wave);
        TPeak(i) = wavestart(i)+idx-1;
    end
    allow = amp > AmpThresh;
    amp = amp(allow);
    TPeak = TPeak(allow);
    
    
    % MUA ISI during peak is putative off
    DOWN = zeros(1,length(spkbin));
    
    TPeak_ms = ceil(TPeak*1000/256);
    spikes = find(spkbin);
    nWav = sum(allow);
    dur = zeros(1,nWav);
    for i=1:nWav
        t = TPeak_ms(i);
        try
            ix = find(spikes>t,1);
            s1 = spikes(ix-1);
            s2 = spikes(ix);
            dur(i) = s2-s1+1;
            if dur(i) >= ISIThresh
                DOWN(s1:s2) = 1;
            end
        end
    end
    nWav = sum(dur >=ISIThresh);
    dur = dur(dur >=ISIThresh);
    amp = amp(dur >=ISIThresh);
    
    % Downy per Bout
    OffOcc(n) = 100*sum(DOWN)/length(DOWN);
    Freq(n) = 1000*nWav/(t2_ms-t1_ms+1);
    Dur(n) = median(dur);
    Amp(n) = median(amp);
    
end


end


